#include "driver.h"

int ExKey;

struct KeySettings keySettings;
struct KeySettings *key_settings = &keySettings;

void msdos_init_input (void)
{
	osd_poll_joystick();
}


void msdos_shutdown_input(void) { }


/*
 * Check if a key is pressed. The keycode is the standard PC keyboard
 * code, as defined in osdepend.h. Return 0 if the key is not pressed,
 * nonzero otherwise. Handle pseudo keycodes.
 */
int osd_key_pressed(int keycode)
{
	switch (keycode)
       	{
       		case OSD_KEY_CANCEL:
       			return ((ExKey & GPC_VK_FL) && (ExKey & GPC_VK_FR));
    		case OSD_KEY_RESET_MACHINE:
    			return ((ExKey & GPC_VK_START) && (ExKey & GPC_VK_SELECT));
       		case OSD_KEY_PAUSE:
       		case OSD_KEY_UNPAUSE:
			return (ExKey & GPC_VK_FR);
		case OSD_KEY_1: /* 1 Player Start == Start Button */
			return ( (ExKey & GPC_VK_START) && !(ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_2: /* 2 Player Start == Joystick UP + Start Button */
			return ( (ExKey & GPC_VK_START) && (ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_3: /* Coin A == L Button */
			return ( (ExKey & GPC_VK_FL) && !(ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_4:	/* Coin B == L Button + Joystick UP */	
			return ( (ExKey & GPC_VK_FL) && (ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_5: /* Coin C == L Button + Joystick RIGHT */
			return ( (ExKey & GPC_VK_FL) && !(ExKey & GPC_VK_UP) && (ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_6: /* Coin D == L Button + Joystick DOWN */
			return ( (ExKey & GPC_VK_FL) && !(ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && (ExKey & GPC_VK_DOWN) );
		case OSD_KEY_7: /* 3 Player Start == Joystick RIGHT + Start Button */
			return ( (ExKey & GPC_VK_START) && !(ExKey & GPC_VK_UP) && (ExKey & GPC_VK_RIGHT) && !(ExKey & GPC_VK_DOWN) );
		case OSD_KEY_8: /* 4 Player Start == Joystick DOWN + Start Button */
			return ( (ExKey & GPC_VK_START) && !(ExKey & GPC_VK_UP) && !(ExKey & GPC_VK_RIGHT) && (ExKey & GPC_VK_DOWN) );
    		default:
			return 0;
        	}
}


void osd_poll_joystick(void)
{ 	
	ExKey=GpKeyGet();
}


/* check if the joystick is moved in the specified direction, defined in */
/* osdepend.h. Return 0 if it is not pressed, nonzero otherwise. */
int osd_joy_pressed(int joycode)
{
        static int f1,f2,f3,c1=0,c2=0,c3=0; /* For Auto-fire */

	switch (joycode)
	{
		case OSD_JOY_LEFT:
		case OSD_JOY2_LEFT:
		case OSD_JOY3_LEFT:
		case OSD_JOY4_LEFT:
		  	if (!gp32_rotate)
		  		return (ExKey & key_settings->JOY_LEFT);
		  	else
		  		return (ExKey & key_settings->JOY_UP);
		case OSD_JOY_RIGHT:
		case OSD_JOY2_RIGHT:
		case OSD_JOY3_RIGHT:
		case OSD_JOY4_RIGHT:
		  	if (!gp32_rotate)
			  	return (ExKey & key_settings->JOY_RIGHT);
		  	else
		  		return (ExKey & key_settings->JOY_DOWN);
		case OSD_JOY_UP:
		case OSD_JOY2_UP:
		case OSD_JOY3_UP:
		case OSD_JOY4_UP:
		  	if (!gp32_rotate)
			  	return (ExKey & key_settings->JOY_UP);
		  	else
			  	return (ExKey & key_settings->JOY_RIGHT);
		case OSD_JOY_DOWN:
		case OSD_JOY2_DOWN:
		case OSD_JOY3_DOWN:
		case OSD_JOY4_DOWN:
		  	if (!gp32_rotate)
		  		return (ExKey & key_settings->JOY_DOWN);
		  	else 
		  		return (ExKey & key_settings->JOY_LEFT);
		case OSD_JOY_FIRE1:
		case OSD_JOY2_FIRE1:
		case OSD_JOY3_FIRE1:
		case OSD_JOY4_FIRE1:
                        if (key_settings->JOY_FIRE1_AUTO) {
                                /* Auto-fire */
				if (!gp32_rotate)
					f1=(ExKey & key_settings->JOY_FIRE1);
				else
					f1=((ExKey & key_settings->JOY_FIRE1) || (ExKey & GPC_VK_START));
				if (!f1) { c1=0; return 0; } c1++; if (c1>=8) { c1=0; return 0; } if (c1>=4) {return 0; } return 1;
                        } else {
				if (!gp32_rotate)
					return (ExKey & key_settings->JOY_FIRE1);
				else
					return ((ExKey & key_settings->JOY_FIRE1) || (ExKey & GPC_VK_START));
			}
		case OSD_JOY_FIRE2:
		case OSD_JOY2_FIRE2:
		case OSD_JOY3_FIRE2:
		case OSD_JOY4_FIRE2:
                        if (key_settings->JOY_FIRE2_AUTO) {
				f2=(ExKey & key_settings->JOY_FIRE2);
				if (!f2) { c2=0; return 0; } c2++; if (c2>=8) { c2=0; return 0; } if (c2>=4) {return 0; } return 1;
			} else {
				return (ExKey & key_settings->JOY_FIRE2);
			}
		case OSD_JOY_FIRE3:
		case OSD_JOY2_FIRE3:
		case OSD_JOY3_FIRE3:
		case OSD_JOY4_FIRE3:
                        if (key_settings->JOY_FIRE3_AUTO) {
				f3=(ExKey & key_settings->JOY_FIRE3);
				if (!f3) { c3=0; return 0; } c3++; if (c3>=8) { c3=0; return 0; } if (c3>=4) {return 0; } return 1;
			} else {
				return (ExKey & key_settings->JOY_FIRE3);
			}
		case OSD_JOY_FIRE4:
		case OSD_JOY2_FIRE4:
		case OSD_JOY3_FIRE4:
		case OSD_JOY4_FIRE4:
		  	return (ExKey & key_settings->JOY_FIRE4);
		case OSD_JOY_FIRE5:
		case OSD_JOY2_FIRE5:
		case OSD_JOY3_FIRE5:
		case OSD_JOY4_FIRE5:
		  	return (ExKey & key_settings->JOY_FIRE5);
		case OSD_JOY_FIRE6:
		case OSD_JOY2_FIRE6:
		case OSD_JOY3_FIRE6:
		case OSD_JOY4_FIRE6:
		  	return (ExKey & key_settings->JOY_FIRE6);
		case OSD_JOY_FIRE7:
		case OSD_JOY2_FIRE7:
		case OSD_JOY3_FIRE7:
		case OSD_JOY4_FIRE7:
		  	return (ExKey & key_settings->JOY_FIRE7);
		case OSD_JOY_FIRE8:
		case OSD_JOY2_FIRE8:
		case OSD_JOY3_FIRE8:
		case OSD_JOY4_FIRE8:
		  	return (ExKey & key_settings->JOY_FIRE8);
		case OSD_JOY_FIRE9:
		case OSD_JOY2_FIRE9:
		case OSD_JOY3_FIRE9:
		case OSD_JOY4_FIRE9:
		  	return (ExKey & key_settings->JOY_FIRE9);
		case OSD_JOY_FIRE10:
		case OSD_JOY2_FIRE10:
		case OSD_JOY3_FIRE10:
		case OSD_JOY4_FIRE10:
		  	return (ExKey & key_settings->JOY_FIRE10);
		case OSD_JOY_FIRE:
		case OSD_JOY2_FIRE:
		case OSD_JOY3_FIRE:
		case OSD_JOY4_FIRE:
			return ( (ExKey & key_settings->JOY_FIRE1) || (ExKey & key_settings->JOY_FIRE2) || (ExKey & key_settings->JOY_FIRE3) ||
				(ExKey & key_settings->JOY_FIRE4) || (ExKey & key_settings->JOY_FIRE5) || (ExKey & key_settings->JOY_FIRE6) );
		default: 
			return 0;
	}
}

int pos_analog_x=0;
int pos_analog_y=0;

/* return a value in the range -128 .. 128 (yes, 128, not 127) */
void osd_analogjoy_read(int *analog_x, int *analog_y)
{
	if (!gp32_rotate) {
		if( (!(ExKey & key_settings->JOY_LEFT)) && (!(ExKey & key_settings->JOY_RIGHT)) ) {
			pos_analog_x=0;
		} else {
			if(ExKey & key_settings->JOY_LEFT) pos_analog_x-=5;
	  		if(ExKey & key_settings->JOY_RIGHT) pos_analog_x+=5;
		}
		if( (!(ExKey & key_settings->JOY_UP)) && (!(ExKey & key_settings->JOY_DOWN)) ) {
			pos_analog_y=0;
		} else {
	  		if(ExKey & key_settings->JOY_UP) pos_analog_y-=5; 
	 		if(ExKey & key_settings->JOY_DOWN) pos_analog_y+=5;
	 	}
	} else {
		if( (!(ExKey & key_settings->JOY_UP)) && (!(ExKey & key_settings->JOY_DOWN)) ) { 
			pos_analog_x=0;
		} else {
			if(ExKey & key_settings->JOY_UP) pos_analog_x-=5;
			if(ExKey & key_settings->JOY_DOWN) pos_analog_x+=5;
		}
		if( (!(ExKey & key_settings->JOY_LEFT)) && (!(ExKey & key_settings->JOY_RIGHT)) ) { 
			pos_analog_y=0;
		} else {
		  	if(ExKey & key_settings->JOY_RIGHT) pos_analog_y-=5; 
			if(ExKey & key_settings->JOY_LEFT) pos_analog_y+=5;
		}
	}
	
	if (pos_analog_x<-128) pos_analog_x=-128;
	if (pos_analog_x>128) pos_analog_x=128;
	if (pos_analog_y<-128) pos_analog_y=-128;
	if (pos_analog_y>128) pos_analog_y=128;
	
	*analog_x = pos_analog_x;
	*analog_y = pos_analog_y;

}

void osd_trak_read(int *deltax,int *deltay)
{
	*deltax = *deltay = 0;
	if (!gp32_rotate) {
		if(ExKey & key_settings->JOY_LEFT) *deltax=-20;
	  	if(ExKey & key_settings->JOY_RIGHT) *deltax=20;
	  	if(ExKey & key_settings->JOY_UP) *deltay=20; 
	 	if(ExKey & key_settings->JOY_DOWN) *deltay=-20;
	} else {
		if(ExKey & key_settings->JOY_UP) *deltax=-20;
		if(ExKey & key_settings->JOY_DOWN) *deltax=20;
	  	if(ExKey & key_settings->JOY_RIGHT) *deltay=20; 
		if(ExKey & key_settings->JOY_LEFT) *deltay=-20;
	}
}

void osd_led_w(int led,int on) { }
